<?php 
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
if (!isset($_SESSION['login'])) {
    if (isset($_COOKIE['remember_login'])) {

        $token = $_COOKIE['remember_login'];
        $q = mysqli_query($conn, "SELECT username FROM user WHERE remember_token='$token'");

        if ($row = mysqli_fetch_assoc($q)) {
            $_SESSION['login'] = true;
            $_SESSION['username'] = $row['username'];
        } else {
            header('Location: login.php');
            exit;
        }

    } else {
        header('Location: login.php');
        exit;
    }
}
   require'koneksi.php';

    // baca isi tabel tangki
    $sql = mysqli_query($koneksi, "SELECT nilai FROM tb_sensor WHERE sensor='air'");
    $data= mysqli_fetch_array($sql);
    $air = $data['nilai'];

    

    // $tinggi_max_tangki = 300; //tinggi tangki dalam cm
    // $jari2 = 1; //jari2 tangki dalam meter
    // $phi = 3.14; //volume = phi * r^2 * tinggi (tinggi air)
    // //ukur tinggi air
    // $tinggi_air = $tinggi_max_tangki - $data['tinggi'];
    // // prosentase ketinggian air
    // $prosentase_tinggi_air = ($tinggi_air/$tinggi_max_tangki)*100; //hasil persen
    // // hitung volume air
    // $volume = $phi * ($jari2 * $jari2) * ($tinggi_air/100); // satuan m3
    // $liter = $volume * 1000 ; // satuan liter

    //bubuk kopi 1
    $bubuk1 = mysqli_query($koneksi, "SELECT persentase FROM tb_kopi WHERE kopi='gula_aren'");
    $databubuk1 = mysqli_fetch_array($bubuk1);
    $bubukk1 = $databubuk1['persentase']; 
    // $kapasitas_maximum = 2000;//2000g
    // $persentase_bubuk1 = round(($berat_sekarang1 / $kapasitas_maximum) * 100);

    //bubuk kopi 2
    $bubuk2 = mysqli_query($koneksi, "SELECT persentase FROM tb_kopi WHERE kopi='cappucino'");
    $databubuk2 = mysqli_fetch_array($bubuk2);
    $bubukk2 = $databubuk2['persentase']; 
    // $persentase_bubuk2 = round(($berat_sekarang2 / $kapasitas_maximum) * 100);

    //bubuk kopi 3
    $bubuk3 = mysqli_query($koneksi, "SELECT persentase FROM tb_kopi WHERE kopi='latte'");
    $databubuk3 = mysqli_fetch_array($bubuk3);
    $bubukk3 = $databubuk3['persentase']; 
    // $persentase_bubuk3 = round(($berat_sekarang3 / $kapasitas_maximum) * 100);

    //suhu
    $suhu = mysqli_query($koneksi, "SELECT nilai FROM tb_sensor WHERE sensor='suhu'");
    $datasuhu = mysqli_fetch_array($suhu);
    $suhu_air = $datasuhu['nilai'];

    //gelas tersedia
    $gelas = mysqli_query($koneksi, "SELECT nilai FROM tb_sensor WHERE sensor='gelas'");
    $datagelas = mysqli_fetch_array($gelas);
    $stok_gelas = $datagelas['nilai'];

    $penjualan = mysqli_query($koneksi, "SELECT * FROM tb_penjualan ORDER BY tanggal DESC LIMIT 1");
    $datapenjualan = mysqli_fetch_array($penjualan);
    $penjualan = $datapenjualan['penjualan'];

    // --- KOPI ---
    $qkopi = mysqli_query($koneksi, "SELECT persentase FROM tb_kopi LIMIT 1");
    $dkopi = mysqli_fetch_assoc($qkopi);
    $kopi = $dkopi['persentase'] ?? 0;
    // --- SENSOR ---
    $qsensor = mysqli_query($koneksi, "SELECT sensor, nilai FROM tb_sensor");
    $datasensor = [];

    while ($d = mysqli_fetch_assoc($qsensor)) {
        $datasensor[$d['sensor']] = $d['nilai'];
    }

    $air   = $datasensor['air']   ?? 0;
    $suhu  = $datasensor['suhu']  ?? 0;
    $gelas = $datasensor['gelas'] ?? 0;

    date_default_timezone_set("Asia/Makassar");
    // --- HEARTBEAT (status = DATETIME) ---
    $qstatus = mysqli_query($koneksi, "SELECT status FROM tb_status WHERE id=1");
    $dstatus = mysqli_fetch_assoc($qstatus);

    $offline = true;

    if ($dstatus && !empty($dstatus['status'])) {
        $selisih = abs(time() - strtotime($dstatus['status']));

        if ($selisih <= 90) {
            $offline = false;
        }
    }

    // --- LOGIKA FINAL ---
    if ($offline) {
        $statusMesin = "Offline";
        $warna = "#DE0300";
    }
    elseif ($kopi <= 10 || $air <= 10 || $suhu <= 60 || $gelas <= 10) {
        $statusMesin = "⚠️Warning";
        $warna = "#ffc107";
    }
    else {
        $statusMesin = "Online";
        $warna = "#28a745";
    }

    $now = date("Y-m-d H:i:s");

    // ambil status lama mode
    $qmode = mysqli_query($koneksi, "SELECT status_mode, pemeliharaan_terakhir FROM tb_status WHERE id=1");
    $dmode = mysqli_fetch_assoc($qmode);

    $statusLama = $dmode['status_mode'] ?? '';

    if ($statusMesin == "Online" && $statusLama != "Online") {
        mysqli_query($koneksi, "
            UPDATE tb_status 
            SET status_mode='$statusMesin',
                pemeliharaan_terakhir='$now'
            WHERE id=1
        ");
    } else {
        mysqli_query($koneksi, "
            UPDATE tb_status 
            SET status_mode='$statusMesin'
            WHERE id=1
        ");
        }
//         echo json_encode([
//         "statusMesin" => $statusMesin,
//         "warna" => $warna,
//         "pemeliharaan" => $dmode['pemeliharaan_terakhir']
// ]);



    // echo "DB Time : ".$dstatus['status']."<br>";
    // echo "Now     : ".date("Y-m-d H:i:s")."<br>";
    // echo "Selisih : ".$selisih."<br>";

 ?>

 <script>
    function refreshStok() {
    fetch("refresh.php")
        .then(response => response.json())
        .then(data => {
            document.getElementById("temperature").innerHTML = data.suhu + "°C";
            document.getElementById("availableGlasses").innerHTML = data.stok_gelas;
            document.getElementById("totalSales").innerHTML = data.penjualan;
            document.getElementById("dataair").innerHTML = data.tinggi + "%";
            document.querySelector(".water-level2").style.height = data.tinggi + "%";
            document.getElementById("bubuk1Percentage").innerHTML = data.bubuk1 + "%";
            document.getElementById("bubuk2Percentage").innerHTML = data.bubuk2 + "%";
            document.getElementById("bubuk3Percentage").innerHTML = data.bubuk3 + "%";
            document.querySelector("#bubuk1").style.height = data.bubuk1 + "%";
            document.querySelector("#bubuk2").style.height = data.bubuk2 + "%";
            document.querySelector("#bubuk3").style.height = data.bubuk3 + "%";
            document.getElementById("pemeliharaan").innerHTML = data.pemeliharaan;


            // document.getElementById("statusMesin").innerHTML = data.statusMesin;
            // document.getElementById("statusMesin").className = "badge bg-" + data.warna;
        })
        .catch(error => console.log("Error:", error));
    }

setInterval(refreshStok, 1000); 
refreshStok(); // panggil pertama kali

    let tipeReset = ""; // "air" atau "gelas"

/* ===== BUKA POPUP ===== */
function konfirmasiKirim(jenis) {
  tipeReset = jenis;

  document.getElementById("popupPesan").innerText =
    jenis === "air"
      ? "Yakin ingin mengisi ulang air ke 100%?"
      : "Yakin ingin mengisi ulang stok gelas";

  document.getElementById("popupReset").classList.add("active");
}

/* ===== BATAL ===== */
function batalKirim() {
  document.getElementById("popupReset").classList.remove("active");
}

/* ===== KIRIM ===== */
function kirimReset() {
  const form =
    tipeReset === "air"
      ? document.getElementById("formKirimAir")
      : document.getElementById("formKirimGelas");

  const formData = new FormData(form);

  fetch(form.action, {
    method: "POST",
    body: formData
  })
    .then(res => res.text())
    .then(data => {
      batalKirim();
      tampilkanNotif("✅ Reset berhasil", true);
      console.log(data);
    })
    .catch(err => {
      tampilkanNotif("❌ Reset gagal", false);
      console.error(err);
    });
}


function tampilkanNotif(pesan, sukses) {
  const notif = document.createElement("div");
  notif.className = "notif " + (sukses ? "success" : "error");
  notif.innerText = pesan;

  document.body.appendChild(notif);

  setTimeout(() => notif.classList.add("show"), 10);
  setTimeout(() => {
    notif.classList.remove("show");
    setTimeout(() => notif.remove(), 300);
  }, 2500);
}

document.addEventListener("DOMContentLoaded", () => {
  const icon = document.getElementById("air");

  setInterval(() => {
    icon.classList.remove("fa-bounce"); // reset dulu

    // paksa reflow supaya animasi restart
    void icon.offsetWidth;

    icon.classList.add("fa-bounce"); // mulai animasi

    setTimeout(() => {
      icon.classList.remove("fa-bounce");
    }, 1000);

  }, 1500);
});

</script>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=320, initial-scale=1.0">
    <title>Monitor Mesin Kopi</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="style.css?v=<?= time(); ?>">
    <script src="https://cdn.lordicon.com/lordicon.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>

    
</head>
<body>
                        <lord-icon
                            src="asset/wired-lineal-615-coffee-machine-hover-pinch.json"
                            trigger="loop"
                            >
                        </lord-icon>
        <!-- POPUP -->
    <div class="modal-overlay" id="popupReset">
      <div class="popup-box">
        <h3>Konfirmasi Reset</h3>
        <p id="popupPesan"></p>

        <div class="modal-actions">
          <button class="btnn batal" onclick="batalKirim()">Batal</button>
          <button class="btnn ya" onclick="kirimReset()">Ya, Reset</button>
        </div>
      </div>
    </div>
    <div class="container">
        <div class="top-bar">
          <a href="logout.php" class="logout-btn">
            <i class="fa-solid fa-arrow-right-from-bracket"></i>
            <span>Logout</span>
          </a>
        </div>


        <div class="header">
            <h1>Monitor Mesin Kopi</h1>
            <h5>Dashboard Manajemen Inventaris</p>
        </div>

        <div class="dashboard">
            <div class="top-section">
                <div class="level-container ">
                    <div class="header-air">
                        <h3>Level Air </h3>
                        <i id="air" class="fas fa-tint text-primary fa-2x"></i>
                        <form id="formKirimAir" action="simpan.php" method="POST" class="formair">
                            <button type="button" onclick="konfirmasiKirim('air')" class="btn btn-link p-1"><i class="fa-solid fa-arrows-rotate text-success fa-spin slow fa-1x"style="color: #2caa84;"></i></button>
                            <input type="hidden" name="kirim100" value="1">
                        </form>
                        
                    </div>
                    <div class="penutup"></div>
                    <div class="water-level">
                        <div class="water-level2"></div>
                        <div class="percentage" id="dataair"><?php echo round ($air); ?>%</div>
                    </div>
                </div>

                <div class="bubuk-section">
                    <div class="bubuk-container">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4>Gula Aren</h4>
                            <i class="fas fa-coffee text-warning"></i>
                        </div>
                        <div class="penutupkopi"></div>
                        <div class="bubuk-level">
                            <div class="bubuk-level2" id="bubuk1"></div>
                            <div class="percentage" id="bubuk1Percentage"><?php echo round ($bubukk1); ?>%</div>
                        </div>
                    </div>
                    <div class="bubuk-container">
                         <div class="d-flex justify-content-between align-items-center">
                        <h4>Cappuccino</h4>
                        <i class="fas fa-coffee text-warning"></i>
                    </div>
                    <div class="penutupkopi"></div>
                        <div class="bubuk-level" >
                        <div class="bubuk-level2" id="bubuk2"></div>
                        <div class="percentage" id="bubuk2Percentage"><?php echo round ($bubukk2); ?>%</div>
                        </div>
                    </div>
                    <div class="bubuk-container">
                         <div class="d-flex justify-content-between align-items-center">
                        <h4>Latte</h4>
                        <i class="fas fa-coffee text-warning"></i>
                    </div>
                    <div class="penutupkopi"></div>
                        <div class="bubuk-level" >
                        <div class="bubuk-level2" id="bubuk3"></div>
                        <div class="percentage" id="bubuk3Percentage"><?php echo round ($bubukk3); ?>%</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bottom-section">
                <div class="temperature-container">
                    <div class="temperature-circle">
                        <h3>Suhu Air <i class="fas fa-thermometer-half text-danger ms-1 fa-beat"></i></h3>
                        <div class="temp-text" id="temperature"><?php echo $suhu_air; ?>°C</div>
                         <p>Optimal 80–90°C</p>
                    </div>
                   
                </div>
                <div class="stats-container">
                    <div class="stat-box">
                        <form id="formKirimGelas" action="simpan.php" method="POST" class="formGelas">
                            <button type="button" onclick="konfirmasiKirim('gelas')"><i class="fa-solid fa-arrows-rotate fa-spin slow"style="color: #2caa84;"></i></button>
                            <input type="hidden" name="kirim50" value="1">
                        </form>
                        <h4> <i class="fas fa-mug-hot text-success mx-2"></i>Gelas Tersedia</h4>
                        <div class="stat-value" id="availableGlasses"><?php echo $stok_gelas; ?></div>
                    </div>
                   <!--  <div class="stat-box">
                        <h4> <i class="fas fa-money-bill-wave text-success mx-2"></i>Total Pendapatan</h4>
                        <div class="stat-value" id="totalRevenue">Rp 450.000</div>
                    </div> -->
                    <div class="stat-box">
                        <h4><i class="fas fa-chart-line text-info mx-2"></i>Penjualan Hari ini</h4>
                        <div class="stat-value" id="totalSales"> <?php echo $penjualan; ?> kopi</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="metric-wrapper">
          <div class="metric-card">
            <div class="metric-body">

              <div class="metric-row">
                <div class="metric-col">
                  <div class="metric-flex">
                    <span>Status Sistem</span>
                   <span 
                      id="statusMesin" 
                      class="badge" 
                      style="background: <?= $warna ?>; color:#fff;">
                      <?= $statusMesin ?>
                    </span>

                  </div>
                </div>

                <div class="metric-col">
                  <div class="metric-flex">
                    <span class="label">Pemeliharaan Terakhir</span>
                    <span id="pemeliharaan" class="valuee"></span>
                  </div>
                </div>

                <div class="metric-col user-info">
                  <div class="metric-user">
                    <span><i class="fas fa-user-circle"></i></span>
                    <span><?= htmlspecialchars($_SESSION['username']); ?></span>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>


        <!-- <div class="row">
            <div class="col">
                <div class="card metric-card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="d-flex justify-content-between">
                                    <span>Status Sistem</span>
                                    <span id="statusMesin" class="badge bg-<?= $warna ?>"><?= $statusMesin ?></span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="maintenance-row d-flex justify-content-between align-items-center">
                                    <span class="label">Pemeliharaan Terakhir</span>
                                    <span id="pemeliharaan" class="value"></span>
                            </div>  
                            </div>
                            <div class="col-md-4 user-info">
                                <div class="d-flex justify-content-end align-items-center gap-4">
                                    <span class="mt-3"><i class="fas fa-user-circle"></i></span>
                                    <span><?= htmlspecialchars($_SESSION['username']); ?></span>
                            </div>
                            </div>
                        </div>
                    </div>                    
                </div>
            </div>                
        </div> -->

    </div>       
</body>
</html>
                                  