const { Client, LocalAuth } = require('whatsapp-web.js');

const client = new Client({
    authStrategy: new LocalAuth({
        clientId: "bot1"
    }),
    puppeteer: {
        headless: false,
        executablePath: 'C:/Program Files (x86)/Google/Chrome/Application/chrome.exe',
        args: [
            '--no-sandbox',
            '--disable-setuid-sandbox',
            '--disable-dev-shm-usage',
            '--disable-gpu',
            '--no-first-run',
            '--no-default-browser-check'
        ]
    }
});

client.on('qr', qr => {
    console.log('📷 Scan QR');
});

client.on('authenticated', () => {
    console.log('✅ Authenticated');
});

client.on('loading_screen', (p, m) => {
    console.log('⏳ Loading...', p, m);
});

client.on('ready', () => {
    console.log('🚀 WhatsApp Bot Ready!');
});

client.on('message', async msg => {
    console.log('📩', msg.from, msg.body);

    if (msg.body.trim().toLowerCase() === 'ping') {
        await msg.reply('pong 🏓');
    }
});

client.initialize();
